const CHANNELS = {
  1: { name: '夜幕', url: 'https://www.yemu.xyz/?url=' },
  2: { name: 'PlayerJy', url: 'https://jx.playerjy.com/?url=' },
  3: { name: '七哥', url: 'https://jx.mmkv.cn/tv.php?url=' },
  4: { name: '大米云', url: 'https://jx.dmflv.cc/?url=' },
  5: { name: '闲鱼云', url: 'https://jx.xymp4.cc/?url=' },
  6: { name: '七七云', url: 'https://jx.77flv.cc/?url=' }
};

chrome.contextMenus.create({
  id: 'getUrl',
  title: 'VidHub解析',
  contexts: ['all']
});

Object.entries(CHANNELS).forEach(([id, channel]) => {
  chrome.contextMenus.create({
    id: `channel_${id}`,
    title: channel.name,
    parentId: 'getUrl',
    contexts: ['all']
  });
});

chrome.contextMenus.onClicked.addListener((info, tab) => {
  if (info.menuItemId.startsWith('channel_')) {
    const channelId = info.menuItemId.split('_')[1];
    const targetUrl = CHANNELS[channelId].url + encodeURIComponent(tab.url);
    chrome.tabs.create({ url: targetUrl });
  }
});